package com.mayi.demo;

import android.app.Application;

import com.gc.call.CallManage;
import com.gc.call.CallParticipationBean;
import com.mayi.fastdevelop.base.BaseApplication;
import com.mayi.fastdevelop.comnon.Configure;
import com.mayi.fastdevelop.comnon.CrashHandler;
import com.mayi.fastdevelop.map.GoMapLocationCallTarget;
import com.mayi.fastdevelop.map.LocationCallTarget;
import com.mayi.fastdevelop.web.GoWebCallTarget;
import com.mayi.fastdevelop.web.InitWebCallTarget;

public class MyApplication extends BaseApplication {

    @Override
    public void onCreate() {
        super.onCreate();
        CallManage.getInstance().addTarget(new LocationCallTarget());
        CallManage.getInstance().addTarget(new GoMapLocationCallTarget());
        CallManage.getInstance().addTarget(new GoWebCallTarget());
        CallManage.getInstance().addTarget(new InitWebCallTarget());
        CallParticipationBean bean = new CallParticipationBean("web_initWeb");
        CallManage.getInstance().handleTarget(bean);
        initBugly("cb8018da1b", true);
        Configure.APP_LOGO = R.mipmap.ic_launcher;
        CrashHandler.getInstance().init(this);
    }

    @Override
    public Application getChildApplication() {
        return this;
    }

    @Override
    public boolean isShowLog() {
        return BuildConfig.DEBUG;
    }
}
