package com.mayi.demo;

import android.os.Bundle;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.mayi.fastdevelop.base.BaseFragment;
import com.mayi.fastdevelop.comnon.AppCallback;
import com.mayi.fastdevelop.comnon.Constant;
import com.mayi.fastdevelop.view.OnMultiClickListener;

public class MyFragment extends BaseFragment {

    private String fragmentTag;
    private Handler handler;

    @Override
    public String getFragmentTag() {
        return fragmentTag;
    }

    @Override
    public void receiveAndHandleInfo(final String data, final AppCallback<String> callback) {
        showToast("我是" + getFragmentTag() + "接收到-->" + data);
        handler.postDelayed(new Runnable() {
            @Override
            public void run() {
                if (callback != null) {
                    callback.callBack(getClass().getName() + "：已处理数据-->" + data);
                }
            }
        }, 1000);
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        handler = new Handler();
        fragmentTag = getArguments().getString("tag");
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_my, container, false);
        TextView tv=view.findViewById(R.id.tv);
        tv.setText("我是"+getFragmentTag());
        view.findViewById(R.id.b1).setOnClickListener(new OnMultiClickListener() {
            @Override
            public void onMultiClick(View v) {
                sendInfo("0", "发送给第一个Fragment", new AppCallback<String>() {
                    @Override
                    public void callBack(String s) {
                        showToast(getFragmentTag() + "接收到处理的数据：" + s);
                    }
                });
            }
        });
        view.findViewById(R.id.b2).setOnClickListener(new OnMultiClickListener() {
            @Override
            public void onMultiClick(View v) {
                sendInfo("1", "发送给第2个Fragment，不需要返回数据", null);
            }
        });
        view.findViewById(R.id.b3).setOnClickListener(new OnMultiClickListener() {
            @Override
            public void onMultiClick(View v) {
                sendInfo(Constant.ACTIVITY_TAG, "发送给Activity，需要返回数据", new AppCallback<String>() {
                    @Override
                    public void callBack(String s) {
                        showToast(getFragmentTag() + "接收到处理的数据：" + s);
                    }
                });
            }
        });
        view.findViewById(R.id.b4).setOnClickListener(new OnMultiClickListener() {
            @Override
            public void onMultiClick(View v) {
                sendInfo(Constant.ACTIVITY_TAG, "发送给Activity，不需要返回数据", null);
            }
        });
        return view;
    }
}
