package com.mayi.demo;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.mayi.fastdevelop.view.lazyLoading.ListLazyLoadingAdapter;

import java.util.List;

public class MyListLazyLoadingAdapter extends ListLazyLoadingAdapter<MyListLazyLoadingAdapter.TVVH> {

    private List<Integer> list;

    public MyListLazyLoadingAdapter(List<Integer> list) {
        this.list = list;
    }


    @Override
    public void onBindItemVH(@NonNull TVVH holder, int position) {
        holder.tv.setText("第"+position+"个");
    }

    @Override
    public List getList() {
        return list;
    }

    @Override
    public TVVH getCreateViewHolder(@NonNull ViewGroup parent,int viewType) {
        return new TVVH(LayoutInflater.from(parent.getContext()).
                inflate(R.layout.item_tv,parent,false));
    }


    public class TVVH extends RecyclerView.ViewHolder {

        TextView tv;

        public TVVH(@NonNull View itemView) {
            super(itemView);
            tv = itemView.findViewById(R.id.tv);
        }
    }

}
