package com.mayi.demo;

import android.os.Bundle;
import android.view.View;
import android.widget.Button;

import androidx.annotation.Nullable;

import com.mayi.fastdevelop.base.BaseActivity;
import com.mayi.fastdevelop.view.OnMultiClickListener;

public class OnMultiClickActivity extends BaseActivity {

    private long last;


    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_onmulticlick);
        Button click = findViewById(R.id.click);
        click.setOnClickListener(new OnMultiClickListener() {
            @Override
            public void onMultiClick(View v) {
                if (last == 0) {
                    showToast("点击时间：" + System.currentTimeMillis());
                } else {
                    showToast("与上次点击时间差：" + (System.currentTimeMillis() - last));
                }
                last = System.currentTimeMillis();
            }
        });
    }

}
