package com.mayi.demo;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;

import androidx.annotation.Nullable;

import com.gc.call.CallConstant;
import com.gc.call.CallManage;
import com.gc.call.CallParticipationBean;
import com.mayi.fastdevelop.base.BaseActivity;
import com.mayi.fastdevelop.comnon.Key;
import com.mayi.fastdevelop.comnon.RequestCode;
import com.mayi.fastdevelop.util.ToolUtils;
import com.mayi.fastdevelop.view.OnMultiClickListener;

public class PageActivity extends BaseActivity {

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_page);
        findViewById(R.id.b1).setOnClickListener(new OnMultiClickListener() {
            @Override
            public void onMultiClick(View v) {
                CallParticipationBean bean = new CallParticipationBean("web_goWeb");
                bean.setContext(PageActivity.this);
                bean.addParameter("url", "https://customer.kujiatech.com/#/?token=8427db8972dd09105a00d62d8bc7cfd5&username=18001874470&v=" + System.currentTimeMillis());
                CallManage.getInstance().handleTarget(bean);
            }
        });
        findViewById(R.id.b2).setOnClickListener(new OnMultiClickListener() {
            @Override
            public void onMultiClick(View v) {
                CallParticipationBean bean = new CallParticipationBean("web_goWeb");
                bean.setContext(PageActivity.this);
                bean.setLooper(CallConstant.LOOPER_NO_MAIN_HANDLER_AND_MIAN_RETURN);
                bean.addParameter("url", "https://customer.kujiatech.com/#/?token=8427db8972dd09105a00d62d8bc7cfd5" +
                        "&username=18001874470&v=" + System.currentTimeMillis() + "&isNeedBackButton=true&userAppTitle=潜客");
                CallManage.getInstance().handleTarget(bean);
            }
        });
        findViewById(R.id.b3).setOnClickListener(new OnMultiClickListener() {
            @Override
            public void onMultiClick(View v) {
                ToolUtils.goScanActivity(v.getContext(), MyScanActivity.class);
            }
        });
        findViewById(R.id.b4).setOnClickListener(new OnMultiClickListener() {
            @Override
            public void onMultiClick(View v) {
                gotoActivity(FragmentInteractiveActivity.class);
            }
        });
        findViewById(R.id.b5).setOnClickListener(new OnMultiClickListener() {
            @Override
            public void onMultiClick(View v) {
                gotoActivity(FragmentInteractiveActivity2.class);
            }
        });
        findViewById(R.id.b6).setOnClickListener(new OnMultiClickListener() {
            @Override
            public void onMultiClick(View v) {
                gotoActivity(StartActivity.class);
            }
        });
        findViewById(R.id.b7).setOnClickListener(new OnMultiClickListener() {
            @Override
            public void onMultiClick(View v) {
                CallParticipationBean bean = new CallParticipationBean("map_goMapLocation");
                bean.setContext(PageActivity.this);
                CallManage.getInstance().handleTarget(bean);
            }
        });
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (requestCode == RequestCode.MAP_LOCATION_ACTIVITY_RESULTCODE) {
            if (resultCode == Activity.RESULT_OK) {
                showToast(data.getStringExtra(Key.AVTIVITY_RESULT));
            }
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

}
