package com.mayi.demo;

import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

import androidx.annotation.Nullable;

import com.alibaba.fastjson.JSON;
import com.mayi.fastdevelop.base.BaseActivity;
import com.mayi.fastdevelop.util.PermissionUtil;
import com.mayi.fastdevelop.view.OnMultiClickListener;
import com.yanzhenjie.permission.Permission;

import java.util.List;

/**
 * 权限申请
 */
public class PermissionActivity extends BaseActivity {

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_permission);
        Button apply = findViewById(R.id.apply);
        final TextView result = findViewById(R.id.result);
        apply.setOnClickListener(new OnMultiClickListener() {
            @Override
            public void onMultiClick(View v) {
                PermissionUtil.requestPermission(new PermissionUtil.PermissionCallback() {
                    @Override
                    public void onSuccess(List<String> data) {
                        showToast("ANT PermissionUtil" + "onSuccess:" + JSON.toJSONString(data));
                        result.setText("请求成功：" + JSON.toJSONString(data));
                    }

                    @Override
                    public void onFail(List<String> data) {
                        showToast("ANT PermissionUtil" + "onFail:" + JSON.toJSONString(data));
                        result.setText("请求失败：" + JSON.toJSONString(data));
                    }
                }, Permission.Group.CAMERA);
            }
        });
    }

}
