package com.mayi.demo;

import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.mayi.fastdevelop.base.BaseActivity;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.listener.OnLoadmoreListener;
import com.scwang.smartrefresh.layout.listener.OnRefreshListener;

/**
 * git 地址：https://github.com/scwang90/SmartRefreshLayout
 */
public class SmartRefreshLayoutActivity extends BaseActivity {

    private int size = 50;
    Handler handler;


    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_smartrefreshlayout);
        handler = new Handler();
        final SmartRefreshLayout layout = findViewById(R.id.layout);
        final RecyclerView list = findViewById(R.id.list);
        list.setLayoutManager(new LinearLayoutManager(this, RecyclerView.VERTICAL, false));
        list.setAdapter(new MyAdapter());

        layout.setEnableRefresh(true);
        layout.setEnableLoadmore(true);
        layout.setOnLoadmoreListener(new OnLoadmoreListener() {
            @Override
            public void onLoadmore(RefreshLayout refreshlayout) {
                handler.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        size = size + 10;
                        list.getAdapter().notifyDataSetChanged();
                        layout.finishLoadmore();//完成加载
                        if (size > 100) {
                            layout.setLoadmoreFinished(true);//数据全部加载完成
                        }
                    }
                }, 1000);
            }
        });
        layout.setOnRefreshListener(new OnRefreshListener() {
            @Override
            public void onRefresh(RefreshLayout refreshlayout) {
                handler.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        size = 50;
                        list.getAdapter().notifyDataSetChanged();
                        layout.finishRefresh();//完成刷新
                    }
                }, 1000);
            }
        });
    }

    class MyAdapter extends RecyclerView.Adapter<MyVH> {

        @NonNull
        @Override
        public MyVH onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
            return new MyVH(new TextView(viewGroup.getContext()));
        }

        @Override
        public void onBindViewHolder(@NonNull MyVH viewHolder, int i) {
            viewHolder.textView.setText("i=" + i);
        }

        @Override
        public int getItemCount() {
            return size;
        }
    }

    class MyVH extends RecyclerView.ViewHolder {

        TextView textView;

        public MyVH(@NonNull View itemView) {
            super(itemView);
            textView = (TextView) itemView;
        }
    }

}
