package com.mayi.fastdevelop.base;

import android.app.Dialog;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.os.Bundle;
import android.view.View;

import androidx.appcompat.app.AppCompatActivity;

import com.mayi.fastdevelop.util.ToastUtil;
import com.mayi.fastdevelop.view.LoadingDialog;

public abstract class BaseActivity extends AppCompatActivity implements View.OnClickListener {

    private Dialog dialog;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);//强制竖屏
    }

    public void showLoadingDialog() {
        if (dialog == null) {
            dialog = LoadingDialog.init(this).setCanTouchOutsideCancel(true).show();
        } else {
            dialog.show();
        }
    }

    public void dismssLoadingDialog() {
        if (dialog != null) {
            dialog.dismiss();
        }
    }

    /**
     * 跳转页面并结束当前页面
     *
     * @param activity
     */
    public void gotoActivityAndFinish(Class activity) {
        Intent intent = new Intent(this, activity);
        startActivity(intent);
        finish();
    }

    /**
     * 跳转页面
     *
     * @param activity
     */
    public void gotoActivity(Class activity) {
        Intent intent = new Intent(this, activity);
        startActivity(intent);
    }

    /**
     * 跳转页面并结束当前页面
     *
     * @param activity
     */
    public void gotoActivityAndFinish(Class activity, Bundle bundle) {
        Intent intent = new Intent(this, activity);
        intent.putExtras(bundle);
        startActivity(intent);
        finish();
    }

    /**
     * 跳转页面
     *
     * @param activity
     */
    public void gotoActivity(Class activity, Bundle bundle) {
        Intent intent = new Intent(this, activity);
        intent.putExtras(bundle);
        startActivity(intent);
    }

    public void showToast(String msg) {
        ToastUtil.show(this, msg);
    }

    // 两次点击按钮之间的点击间隔不能少于500毫秒
    private final int MIN_CLICK_DELAY_TIME = 500;
    private long lastClickTime;
    private int lastViewId = 0;

    @Override
    public void onClick(View v) {
        if (lastViewId == v.getId() && System.currentTimeMillis() - lastClickTime < MIN_CLICK_DELAY_TIME) {
            lastViewId = v.getId();
            return;
        }
        lastViewId = v.getId();
        lastClickTime = System.currentTimeMillis();
        onMultiClick(v);
    }

    //防止重复点击
    protected void onMultiClick(View v) {
    }

    @Override
    protected void onDestroy() {
        dismssLoadingDialog();
        super.onDestroy();
    }
}
