package com.mayi.fastdevelop.base;

import android.Manifest;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.provider.MediaStore;


import androidx.core.content.FileProvider;

import com.mayi.fastdevelop.util.PermissionUtil;

import java.io.File;
import java.util.List;

public abstract class BaseCutPicturesActivity extends BaseActivity {

    private final int REQUESTCODE_CAMERA = 100;//拍照回调
    private final int REQUESTCODE_CUT_PICTURES = 101;//裁剪图片回调
    private String imgPath;//裁剪保存图片地址
    private File cameraSavePath;//拍照保存图片地址
    private String[] permissions = {Manifest.permission.CAMERA, Manifest.permission.WRITE_EXTERNAL_STORAGE};

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        if (outState!=null){
            outState.putString("imgPath",imgPath);
            outState.putSerializable("cameraSavePath",cameraSavePath);
        }
        super.onSaveInstanceState(outState);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState!=null){
            imgPath=savedInstanceState.getString("imgPath");
            cameraSavePath= (File) savedInstanceState.getSerializable("cameraSavePath");
        }
        PermissionUtil.requestPermission(new PermissionUtil.PermissionCallback() {
            @Override
            public void onSuccess(List<String> data) {
            }

            @Override
            public void onFail(List<String> data) {
                showToast("需要获取您的相册、照相使用权限");
                finish();
            }
        }, permissions);
    }

    //激活相册操作
    protected void goPhotoAlbum() {
        Intent intent = new Intent();
        intent.setAction(Intent.ACTION_PICK);
        intent.setType("image/*");
        startActivityForResult(intent, 2);
    }

    //激活相机操作
    protected void goCamera() {
        cameraSavePath = new File(Environment.getExternalStorageDirectory().getPath() + "/" + getPackageName() + "/" + System.currentTimeMillis() + ".jpg");
        Intent intent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
        Uri uri=null;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            uri = FileProvider.getUriForFile(this, getPackageName() + ".uri", cameraSavePath);
            intent.addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION);
        } else {
            uri = Uri.fromFile(cameraSavePath);
        }
        intent.putExtra(MediaStore.EXTRA_OUTPUT, uri);
        startActivityForResult(intent, REQUESTCODE_CAMERA);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == REQUESTCODE_CAMERA && resultCode == RESULT_OK) {
            Uri uri=null;
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                uri = FileProvider.getUriForFile(this, getPackageName() + ".uri", cameraSavePath);
            } else {
                uri = Uri.fromFile(cameraSavePath);
            }
            photoClip(uri);
        } else if (requestCode == 2 && resultCode == RESULT_OK) {
            photoClip(data.getData());
        } else if (requestCode == REQUESTCODE_CUT_PICTURES && resultCode == RESULT_OK) {
            Bundle bundle = data.getExtras();
            if (bundle != null) {
                getBitmapPath(imgPath);
            }
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    //获取裁剪图片本地地址
    protected void getBitmapPath(String imgPath) {
    }

    protected void photoClip(Uri uri) {
        // 调用系统中自带的图片剪裁
        Intent intent1 = new Intent();
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            intent1.addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION);
        }
        /*设置调用裁剪工具的action*/
        intent1.setAction("com.android.camera.action.CROP");
        /*创建一个指向需要操作文件（filename）的文件流。（可解决无法“加载问题”）*/
        intent1.setDataAndType(uri, "image/*");
        intent1.putExtra("crop", "true");
        intent1.putExtra("scale", true);
        intent1.putExtra("return-data", false);
        imgPath = Environment.getExternalStorageDirectory().getPath() + "/" + System.currentTimeMillis() + ".jpg";
        Uri uritempFile = Uri.parse("file://" + "/" + imgPath);
        intent1.putExtra(MediaStore.EXTRA_OUTPUT, uritempFile);
        intent1.putExtra("outputFormat", Bitmap.CompressFormat.JPEG.toString());
        intent1.putExtra("noFaceDetection", true);
        startActivityForResult(intent1, REQUESTCODE_CUT_PICTURES);
    }

}
