package com.mayi.fastdevelop.base;

import android.app.Dialog;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;

import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentPagerAdapter;
import androidx.fragment.app.FragmentTransaction;
import androidx.viewpager.widget.ViewPager;

import com.mayi.fastdevelop.comnon.AppCallback;
import com.mayi.fastdevelop.comnon.Constant;
import com.mayi.fastdevelop.util.ToastUtil;
import com.mayi.fastdevelop.view.LoadingDialog;

import java.util.List;

public abstract class BaseFragmentActivity extends FragmentActivity {

    private List<BaseFragment> list;//list不能为null，否则无法传递数据，传递数据是通过list找到Fragment的

    /**
     * 数量Fragment发送过来的数据
     *
     * @param data
     * @param callback
     */
    public abstract void handleInfo(String data, AppCallback<String> callback);

    public void setList(List<BaseFragment> list) {
        this.list = list;
    }

    public void viewPagerLoadFragments(final List<BaseFragment> list, ViewPager viewPager) {
        this.list = list;
        viewPager.setAdapter(new FragmentPagerAdapter(getSupportFragmentManager()) {
            @Override
            public Fragment getItem(int i) {
                return list.get(i);
            }

            @Override
            public int getCount() {
                return list.size();
            }
        });
    }

    /**
     * 把Fragment添加到页面中并显示第一个Fragment
     *
     * @param list
     */
    public void addFragmentsAndShowFragment(List<BaseFragment> list, int viewId) {
        this.list = list;
        FragmentTransaction transaction = getSupportFragmentManager().beginTransaction();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                BaseFragment fragment = list.get(i);
                transaction.add(viewId, fragment).hide(fragment);
            }
            transaction.show(list.get(0));
            transaction.commit();
        }
    }

    /**
     * 显示选中的Fragment
     *
     * @param index
     */
    public void showFragment(int index) {
        if (list != null && list.size() > 0 && index < list.size()) {
            BaseFragment baseFragment = list.get(index);
            if (!baseFragment.isHidden() && baseFragment.isVisible()) {
                return;
            }
            FragmentTransaction transaction = getSupportFragmentManager().beginTransaction();
            for (int i = 0; i < list.size(); i++) {
                BaseFragment fragment = list.get(i);
                transaction.hide(fragment);
            }
            transaction.show(baseFragment).commit();
        }
    }

    /**
     * 接收Fragment发送过来的数据，如果tag=Activity，在Activity中处理数据
     *
     * @param tag
     * @param data
     * @param callback
     */
    public void receiveInfo(String tag, String data, AppCallback<String> callback) {
        if (TextUtils.equals(Constant.ACTIVITY_TAG, tag)) {
            handleInfo(data, callback);
        } else {
            if (list != null && list.size() > 0) {
                for (int i = 0; i < list.size(); i++) {
                    BaseFragment fragment = list.get(i);
                    if (TextUtils.equals(tag, fragment.getFragmentTag())) {
                        fragment.receiveAndHandleInfo(data, callback);
                    }
                }
            }
        }
    }

    private Dialog dialog;

    public void showLoadingDialog() {
        if (dialog == null) {
            dialog = LoadingDialog.init(this).show();
        } else {
            dialog.show();
        }
    }

    public void dismssLoadingDialog() {
        if (dialog != null) {
            dialog.dismiss();
        }
    }

    /**
     * 跳转页面并结束当前页面
     *
     * @param activity
     */
    public void gotoActivityAndFinish(Class activity) {
        Intent intent = new Intent(this, activity);
        startActivity(intent);
        finish();
    }

    /**
     * 跳转页面
     *
     * @param activity
     */
    public void gotoActivity(Class activity) {
        Intent intent = new Intent(this, activity);
        startActivity(intent);
    }

    /**
     * 跳转页面并结束当前页面
     *
     * @param activity
     */
    public void gotoActivityAndFinish(Class activity, Bundle bundle) {
        Intent intent = new Intent(this, activity);
        intent.putExtras(bundle);
        startActivity(intent);
        finish();
    }

    /**
     * 跳转页面
     *
     * @param activity
     */
    public void gotoActivity(Class activity, Bundle bundle) {
        Intent intent = new Intent(this, activity);
        intent.putExtras(bundle);
        startActivity(intent);
    }

    public void showToast(String msg) {
        ToastUtil.show(this, msg);
    }

    @Override
    protected void onDestroy() {
        dismssLoadingDialog();
        super.onDestroy();
    }

}
