package com.mayi.fastdevelop.commonpage;

import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;

import androidx.annotation.Nullable;

import com.mayi.fastdevelop.base.BaseActivity;
import com.mayi.fastdevelop.comnon.Key;
import com.mayi.fastdevelop.comnon.UserManager;
import com.mayi.fastdevelop.util.SpUtil;


/**
 * APP启动闪屏页
 */
public abstract class BaseStartActivity<T extends BaseActivity, T1 extends BaseActivity, T2 extends BaseActivity> extends BaseActivity {

    private Handler mHandler;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        mHandler = new Handler();
        mHandler.postDelayed(new Runnable() {
            @Override
            public void run() {
                gotoNext();
            }
        }, 1000);
    }

    private void gotoNext() {
        if (SpUtil.get(Key.FIRST_LOGIN, true)) { // 首次登录 -- 》广告页
            SpUtil.set(Key.FIRST_LOGIN, false);
            gotoActivityAndFinish(getGuideActivity());
        } else {// 非首次 --> 判断有没有缓存用户信息
            if (TextUtils.isEmpty(SpUtil.get(Key.USER_INFO, ""))) {
                // 没有本地缓存 直接登录
                gotoActivityAndFinish(getLoginActivity());
            } else {
                // 有本地缓存  免登录 直接到首页
                UserManager.getUserInfo();
                gotoActivityAndFinish(getMainActivity());
            }
        }
    }

    @Override
    protected void onDestroy() {
        mHandler.removeCallbacksAndMessages(null);
        super.onDestroy();
    }

    public abstract Class<T> getGuideActivity();//获取广告页Activity

    public abstract Class<T1> getLoginActivity();//获取登录页Activity

    public abstract Class<T2> getMainActivity();//获取首页Activity

}
