package com.mayi.fastdevelop.commonpage.zxing.decoding;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;

import com.google.zxing.BinaryBitmap;
import com.google.zxing.Result;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.QRCodeReader;
import com.mayi.fastdevelop.R;
import com.mayi.fastdevelop.commonpage.zxing.BaseScanActivity;
import com.mayi.fastdevelop.commonpage.zxing.camera.CameraManager;
import com.mayi.fastdevelop.commonpage.zxing.camera.PlanarYUVLuminanceSource;

final class DecodeHandler extends Handler {

    private static final String TAG = DecodeHandler.class.getSimpleName();

    private final BaseScanActivity activity;
    private final QRCodeReader mQRCodeReader;

    DecodeHandler(BaseScanActivity activity) {
        this.activity = activity;
        this.mQRCodeReader = new QRCodeReader();
    }

    @Override
    public void handleMessage(Message message) {
        int id = message.what;
        if (id == R.id.decode) {
            decode((byte[]) message.obj, message.arg1, message.arg2);
        } else if (id == R.id.quit) {
            if (Looper.myLooper() != null) {
                Looper.myLooper().quit();
            }
        }

    }

    /**
     * Decode the data within the viewfinder rectangle, and time how long it took. For efficiency,
     * reuse the same reader objects from one decode to the next.
     *
     * @param data   The YUV preview frame.
     * @param width  The width of the preview frame.
     * @param height The height of the preview frame.
     */
    private void decode(byte[] data, int width, int height) {
        long start = System.currentTimeMillis();
        Result rawResult = null;

        //modify here
        byte[] rotatedData = new byte[data.length];
        for (int y = 0; y < height; y++) {
            for (int x = 0; x < width; x++)
                rotatedData[x * height + height - y - 1] = data[x + y * width];
        }
        int tmp = width; // Here we are swapping, that's the difference to #11
        width = height;
        height = tmp;

        PlanarYUVLuminanceSource source = CameraManager.get().buildLuminanceSource(rotatedData, width, height);
        if (source != null) {
            BinaryBitmap bitmap = new BinaryBitmap(new HybridBinarizer(source));
            try {
                rawResult = mQRCodeReader.decode(bitmap);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        if (rawResult != null) {
            long end = System.currentTimeMillis();
            Log.d(TAG, "Found barcode (" + (end - start) + " ms):\n" + rawResult.toString());
            Message message = Message.obtain(activity.getHandler(), R.id.decode_succeeded, rawResult);
            message.sendToTarget();
        } else {
            Message message = Message.obtain(activity.getHandler(), R.id.decode_failed);
            message.sendToTarget();
        }
    }

}
