package com.mayi.fastdevelop.commonpage.zxing.decoding;

import android.os.Handler;
import android.os.Looper;

import com.mayi.fastdevelop.commonpage.zxing.BaseScanActivity;

import java.util.concurrent.CountDownLatch;

final class DecodeThread extends Thread {

    private final BaseScanActivity activity;
    private Handler handler;
    private final CountDownLatch handlerInitLatch;

    DecodeThread(BaseScanActivity activity) {
        this.activity = activity;
        handlerInitLatch = new CountDownLatch(1);
    }

    Handler getHandler() {
        try {
            handlerInitLatch.await();
        } catch (InterruptedException ie) {
            // continue?
        }
        return handler;
    }

    @Override
    public void run() {
        Looper.prepare();
        handler = new DecodeHandler(activity);
        handlerInitLatch.countDown();
        Looper.loop();
    }
}
