package com.mayi.fastdevelop.comnon;

import android.text.TextUtils;

import com.alibaba.fastjson.JSON;
import com.mayi.fastdevelop.bean.UserInfo;
import com.mayi.fastdevelop.util.SpUtil;

public class UserManager {

    private static UserInfo userInfo;

    /**
     * 获取本地的用户信息
     *
     * @return 用户信息
     */
    public static UserInfo getUserInfo() {
        if (userInfo == null) {
            synchronized (UserManager.class) {
                if (userInfo == null) {
                    String s = SpUtil.get(Key.USER_INFO, "");
                    if (!TextUtils.isEmpty(s)) {
                        userInfo = JSON.parseObject(s, UserInfo.class);
                    }
                }
            }
        }
        return userInfo;
    }

    /**
     * 设置用户信息
     *
     * @param json
     */
    public static void setUserInfo(String json) {
        if (!TextUtils.isEmpty(json)) {
            synchronized (UserManager.class) {
                SpUtil.set(Key.USER_INFO, json);
                userInfo = JSON.parseObject(json, UserInfo.class);
            }
        }
    }

    /**
     * 设置用户信息
     *
     * @param userInfo
     */
    public static void setUserInfo(UserInfo userInfo) {
        if (userInfo != null) {
            synchronized (UserManager.class) {
                SpUtil.set(Key.USER_INFO, JSON.toJSONString(userInfo));
                UserManager.userInfo = userInfo;
            }
        }
    }

    /**
     * 清除用户信息
     */
    public static void clearUserInfo() {
        synchronized (UserManager.class) {
            SpUtil.set(Key.USER_INFO, null);
            userInfo = null;
        }
    }
}
