package com.mayi.fastdevelop.okhttp;

import android.text.TextUtils;

import com.mayi.fastdevelop.comnon.Constant;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class NetWorkBuilder {


    private String method = Constant.NETWORK_METHOD_POST;       //发起请求方式get/post
    private String url;
    private Map<String, String> headers = new HashMap<>();
    private ResultCallback callback;

    private JSONObject params = new JSONObject();
    private String stringParam;

    public NetWorkBuilder setStringParam(String stringParam) {
        this.stringParam = stringParam;
        return this;
    }

    public NetWorkBuilder setCallback(ResultCallback callback) {
        this.callback = callback;
        return this;
    }

    public NetWorkBuilder setMethod(String method) {
        this.method = method;
        return this;
    }

    public NetWorkBuilder setUrl(String url) {
        this.url = url;
        return this;
    }

    public NetWorkBuilder addHeader(String key, String header) {
        headers.put(key, header);
        return this;
    }

    public NetWorkBuilder addParam(String key, Object param) {
        try {
            params.put(key, param);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return this;
    }

    public void execute() {
        if (TextUtils.isEmpty(url)) {
            return;
        }

        if (TextUtils.equals(method, Constant.NETWORK_METHOD_GET)) {
            sendGet();
        } else if (TextUtils.equals(method, Constant.NETWORK_METHOD_POST)) {
            sendPost();
        }
    }

    //发起post请求
    private void sendPost() {
        if (!TextUtils.isEmpty(stringParam)) {
            NetWorkUtil.getInstance().performSynPostHttpRequest(url, stringParam, callback);
        } else if (params.toString().length() > 2) {
            NetWorkUtil.getInstance().performSynPostHttpRequest(url, params.toString(), callback);
        } else {
            NetWorkUtil.getInstance().performSynPostHttpRequest(url, null, callback);
        }
    }

    //发起get请求
    private void sendGet() {
        if (!TextUtils.isEmpty(stringParam)) {
            NetWorkUtil.getInstance().performSynGetHttpRequest(url + "?" + stringParam, callback);
        } else if (params.toString().length() > 2) {
            StringBuilder builder = new StringBuilder();
            builder.append("?");
            Iterator<String> keys = params.keys();
            while (keys.hasNext()) {
                String key = keys.next().toString();
                String value = params.optString(key);
                builder.append(key);
                builder.append("=");
                builder.append(value);
                builder.append("&");
            }
            String s = builder.toString();
            s.substring(0, s.length() - 1);
            NetWorkUtil.getInstance().performSynGetHttpRequest(url + s, callback);
        } else {
            NetWorkUtil.getInstance().performSynGetHttpRequest(url, callback);
        }
    }

}
