package com.mayi.fastdevelop.okhttp;


import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class ResultCallback<T> {

    public abstract void onFail(String msg);

    public abstract void onSuccess(T t);
    /**
     * 泛型具体实体Tyle
     *
     * @param index
     * @return
     */
    public Type getGenericType(int index) {
        Type genType = getClass().getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            return Object.class;
        }
        Type[] params = ((ParameterizedType) genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            throw new RuntimeException("Index outof bounds");
        }
        return params[index];
    }

}
