package com.mayi.fastdevelop.util;

import android.annotation.SuppressLint;
import android.text.TextUtils;

import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

/**
 * 日期工具
 */
public class DateUtil {

    public static final String TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String MONTH_DATE_HOUR_MINS_FROMAT = "M月dd日 HH:mm";
    public static final String CHINA_MONTH_DATE_FORMAT = "MM月dd日";
    public static final String HYPHEN_FORMAT_YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String CHINA_FORMAT_YYYY_MM_DD = "yyyy年MM月dd日";
    public static final String CHINA_FORMAT_YYYY_MM_DD_HH_MM = "yyyy年MM月dd日 HH点mm分";
    public static final String CHINA_FORMAT_YYYY_MM_DD_HH_MM_SS = "yyyy年MM月dd日 HH点mm分ss秒";


    /**
     * 获取当前时间
     */
    public static String getCurrentTime() {
        SimpleDateFormat formatter = new SimpleDateFormat(TIME_FORMAT, Locale.getDefault());
        return formatter.format(new Date());
    }

    /**
     * 获取当前时间
     */
    public static String getCurrentTimeShort() {
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT, Locale.getDefault());
        return formatter.format(new Date());
    }

    /**
     * 获取当前时间的月日，时分
     *
     * @return
     */
    public static String getCurrentMonthDateHourMin() {
        SimpleDateFormat formatter = new SimpleDateFormat(MONTH_DATE_HOUR_MINS_FROMAT, Locale.getDefault());
        return formatter.format(new Date());
    }

    /**
     * 获取当前日期
     */
    public static String getCurrentDate() {
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT, Locale.getDefault());
        return formatter.format(new Date());
    }

    /**
     * 将长时间格式字符串转换为时间 yyyy-MM-dd HH:mm:ss
     *
     * @param strDate
     * @return
     */
    public static Date strToDateLong(String strDate) {
        SimpleDateFormat formatter = new SimpleDateFormat(TIME_FORMAT, Locale.getDefault());
        ParsePosition pos = new ParsePosition(0);
        Date strtodate = formatter.parse(strDate, pos);
        return strtodate;
    }

    /**
     * 将时间格式字符串转换为时间Date
     *
     * @param strDate
     * @return
     */
    public static Date strToDate(String strDate, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.getDefault());
        Date date = null;
        try {
            date = formatter.parse(strDate);
        } catch (ParseException e) {
            e.printStackTrace();
        }

        return date;
    }

    /**
     * 将长时间格式字符串转换为时间 yyyy-MM-dd HH:mm:ss
     *
     * @param strDate
     * @return
     */
    public static Date strToDateLong(String strDate, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.getDefault());
        ParsePosition pos = new ParsePosition(0);
        Date strtodate = formatter.parse(strDate, pos);
        return strtodate;
    }

    /**
     * 将长时间格式时间转换为字符串 yyyy-MM-dd HH:mm:ss
     *
     * @param dateDate
     * @return
     */
    public static String dateToStrLong(java.util.Date dateDate, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.getDefault());
        String dateString = formatter.format(dateDate);
        return dateString;
    }

    /**
     * 将长时间格式时间转换为字符串 yyyy-MM-dd HH:mm:ss
     *
     * @param dateDate
     * @return
     */
    public static String dateToStrLong2(java.util.Date dateDate) {
        SimpleDateFormat formatter = new SimpleDateFormat(TIME_FORMAT, Locale.getDefault());
        String dateString = formatter.format(dateDate);
        return dateString;
    }

    /**
     * 两个时间进行比较
     *
     * @param currentTime 当前时间
     * @param nextTime    下个时间
     * @return 0 刚好是今天  1超过范围  -1 范围之内
     */
    public static long compareTime(String currentTime, String nextTime) {
        SimpleDateFormat formatter = new SimpleDateFormat(TIME_FORMAT, Locale.getDefault());
        try {
            Date dt1 = formatter.parse(currentTime);
            Date dt2 = formatter.parse(nextTime);
            return dt2.getTime() - dt1.getTime();
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return 0;
    }

    /**
     * 判断两个日期是否同一天
     *
     * @param currentTime 当前时间
     * @param nextTime    下个时间
     * @return true 是今天  不是今天
     */
    public static boolean isSameDate(String currentTime, String nextTime) {
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT, Locale.getDefault());
        try {
            Date date1 = formatter.parse(currentTime);
            Date date2 = formatter.parse(nextTime);
            Calendar cal1 = Calendar.getInstance();
            cal1.setTime(date1);
            Calendar cal2 = Calendar.getInstance();
            cal2.setTime(date2);
            boolean isSameYear = cal1.get(Calendar.YEAR) == cal2.get(Calendar.YEAR);
            boolean isSameMonth = isSameYear && cal1.get(Calendar.MONTH) == cal2.get(Calendar.MONTH);
            boolean isSameDate = isSameMonth && cal1.get(Calendar.DAY_OF_MONTH) == cal2.get(Calendar.DAY_OF_MONTH);
            return isSameDate;
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return false;
    }

    /**
     * 两个日期进行比较
     *
     * @param currentDate 当前日期
     * @param nextDate    下个日期
     */
    public static boolean compareDate(String currentDate, String nextDate) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT, Locale.getDefault());
            Date d1 = sdf.parse(currentDate);
            Date d2 = sdf.parse(nextDate);
            return d1.before(d2);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return false;
    }

    /**
     * 获取当月的 天数
     */
    public static int getCurrentMonthDays() {
        Calendar a = Calendar.getInstance();
        a.set(Calendar.DATE, 1);
        a.roll(Calendar.DATE, -1);
        int maxDate = a.get(Calendar.DATE);
        return maxDate;
    }

    /**
     * 获取上个月的 天数
     */
    public static int getMonthDaysAgo() {
        //获取当前时间
        Calendar cal = Calendar.getInstance();
        //调到上个月
        cal.add(Calendar.MONTH, -1);
        //得到一个月最最后一天日期(31/30/29/28)
        return cal.getActualMaximum(Calendar.DAY_OF_MONTH);

    }

    /**
     * 获取今天是本月第几天
     */
    public static int getCurrentMonthDayIndex() {
        return Calendar.getInstance().get(Calendar.DAY_OF_MONTH);
    }

    /**
     * 获取本月数字
     */
    public static int getCurrentMonthIndex() {
        return Calendar.getInstance().get(Calendar.MONTH);
    }

    /**
     * 获取本年数字
     */
    public static int getCurrentYear() {
        return Calendar.getInstance().get(Calendar.YEAR);
    }

    /**
     * 获取当月第一天 是星期几
     *
     * @return 周日 1  周一 2   ...
     */
    public static int getMonthFirstDayIndexForWeek() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.DAY_OF_MONTH, 1);
        return calendar.get(Calendar.DAY_OF_WEEK);//这个结果是以星期天为第一天算出来的，如果要换成星期一开始，减1就行了
    }

    /**
     * 获取今天 是星期几
     *
     * @return 周日 1  周一 2   ...
     */
    public static int getDayIndexForWeek() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(Calendar.DAY_OF_WEEK);//这个结果是以星期天为第一天算出来的，如果要换成星期一开始，减1就行了
    }

    /**
     * 获取今天 是星期几
     *
     * @return 周日 1  周一 2   ...
     */
    public static String getDayIndexForWeekString() {
        Calendar calendar = Calendar.getInstance();
        int week = calendar.get(Calendar.DAY_OF_WEEK);//这个结果是以星期天为第一天算出来的，如果要换成星期一开始，减1就行了
        String weekString = "";
        switch (week) {
            case 1:
                weekString = "日";
                break;
            case 2:
                weekString = "一";
                break;
            case 3:
                weekString = "二";
                break;
            case 4:
                weekString = "三";
                break;
            case 5:
                weekString = "四";
                break;
            case 6:
                weekString = "五";
                break;
            case 7:
                weekString = "六";
                break;
        }
        return weekString;
    }


    public static String dataToZhDate(String str) {
        try {
            // 1、将String转换成date
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
            Date date = fmt.parse(str);
            SimpleDateFormat formatter = new SimpleDateFormat("MM月dd日 HH:mm", Locale.getDefault());
            String dateString = formatter.format(date);
            return dateString;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String dataToZhDate(String str, String format) {
        try {
            // 1、将String转换成date
            SimpleDateFormat fmt = new SimpleDateFormat("HH:mm", Locale.getDefault());
            Date date = fmt.parse(str);
            SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.getDefault());
            String dateString = formatter.format(date);
            return dateString;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    /**
     * 将inputFormat格式的日期dateString转换为outputFormat格式
     *
     * @param dateString
     * @param inputFormat
     * @param outputFormat
     * @return outputFormat格式的日期String
     */
    public static String dateStringFormatChange(String dateString, String inputFormat, String outputFormat) {
        try {
            SimpleDateFormat fmt = new SimpleDateFormat(inputFormat, Locale.getDefault());
            Date date = fmt.parse(dateString);

            SimpleDateFormat formatter = new SimpleDateFormat(outputFormat, Locale.getDefault());
            return formatter.format(date);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String dataToZhDate2(String str, String format) {
        try {
            // 1、将String转换成date
            SimpleDateFormat fmt = new SimpleDateFormat(TIME_FORMAT, Locale.getDefault());
            Date date = fmt.parse(str);
            SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.getDefault());
            String dateString = formatter.format(date);
            return dateString;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String dataToZhDate3(String str, String format, int dec) {
        try {
            // 1、将String转换成date
            SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.getDefault());
            Calendar c = Calendar.getInstance();
            c.setTime(new Date());
            c.add(Calendar.DATE, 0 - dec);
            Date date = c.getTime();
            return formatter.format(date);

        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    /**
     * 获取时间
     *
     * @return
     */

    @SuppressLint("SimpleDateFormat")
    public static String getStringDate(Date d) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String str = df.format(d);
        return str;
    }

    /**
     * 获取时间
     *
     * @return
     */

    @SuppressLint("SimpleDateFormat")
    public static String getStringDateLong(Date d) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy年MM月dd日 HH时mm分");
        String str = df.format(d);
        return str;
    }

    /**
     * 获取时间
     *
     * @return
     */

    @SuppressLint("SimpleDateFormat")
    public static String getStringDateLongTicket(Date d) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy年MM月dd日 HH:mm");
        String str = df.format(d);
        return str;
    }

    /**
     * 获取时间
     *
     * @return
     */
    @SuppressLint("SimpleDateFormat")
    public static String getStringDateShort(Date d) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy年MM月dd日");
        String dateString = formatter.format(d);
        return dateString;
    }

    /**
     * 获取时间
     *
     * @return
     */
    @SuppressLint("SimpleDateFormat")
    public static String getMessageStringDate(Date d) {
        SimpleDateFormat formatter = new SimpleDateFormat("MM月dd日 HH:mm");
        String dateString = formatter.format(d);
        return dateString;
    }

    /**
     * 获取时间
     *
     * @return
     */
    @SuppressLint("SimpleDateFormat")
    public static String getStringDateYYMMDDhhmm(Date d) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String dateString = formatter.format(d);
        return dateString;
    }


    public static boolean isServiceHours() {
        boolean isServiceHours = false;
        Date startDate = new Date();
        startDate.setHours(7);
        startDate.setMinutes(30);
        Date endDate = new Date();
        endDate.setHours(20);
        endDate.setMinutes(00);

        Date curDate = new Date();
        if (curDate.after(startDate) && curDate.before(endDate)) {
            isServiceHours = true;
        }

        return isServiceHours;
    }

    public static long timeIntervalOfMinutes(Date sDate1, Date sDate2) {
        long minutes = 0;
        if (sDate1 != null && sDate2 != null) {
            long temp = sDate1.getTime() - sDate2.getTime();
//            long hours = temp / 1000 / 3600; // 相差小时数
            long mins = temp / 1000 / 60;
            minutes = mins;
        }
        return minutes;
    }

    public static long timeIntervalOfMinutes(String sDate1, String sDate2) {
        long minutes = 0;
        if (!TextUtils.isEmpty(sDate1) && !TextUtils.isEmpty(sDate2)) {
            String formatStr = "yyyy-MM-dd HH:mm:ss";
            SimpleDateFormat format = new SimpleDateFormat(formatStr, Locale.getDefault());
            try {
                Date date1 = format.parse(sDate1);
                Date date2 = format.parse(sDate2);
                long temp = date1.getTime() - date2.getTime();
//                long hours = temp / 1000 / 3600; // 相差小时数
                long mins = temp / 1000 / 60;
                minutes = mins;
            } catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return minutes;
    }

    /**
     * 获得时间标签
     *
     * @param time
     * @return
     */
    public static String getTimeLabel(String time) {
        String timeLabel = "";
        if (TextUtils.isEmpty(time)) {
            return timeLabel;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
        long publishedTime = 0;
        try {
            Date date = format.parse(time);
            publishedTime = date.getTime();
        } catch (ParseException e) {
            e.printStackTrace();
        }

        if (publishedTime > 0) {
            Date Pubdate = new Date(publishedTime);
            Date nowDate = new Date();
            long temp = Math.abs(nowDate.getTime() - Pubdate.getTime());
            long years = temp / 1000 / 3600 / 24 / 365;
            long months = temp / 1000 / 3600 / 24 / 30;
            long days = temp / 1000 / 3600 / 24;
            long hours = temp / 1000 / 3600; // 相差小时数
            long mins = temp / 1000 / 60;

            if (mins < 5) {
                timeLabel = "刚刚";
            } else if (mins >= 5 && mins < 60) {
                timeLabel = mins + "分钟前";
            } else if (mins >= 60 && hours < 24) {
                timeLabel = hours + "小时前";
            } else if (hours >= 24 && days < 30) {
                timeLabel = days + "天前";
            } else if (days >= 30 && years < 1) {
                timeLabel = months + "个月前";
            } else if (years >= 1) {
                timeLabel = years + "年前";
            }
        }

        return timeLabel;
    }

    /**
     * 获得时间标签 兼容未来时间
     *
     * @param time
     * @return
     */
    public static String getTimeTips(String time) {
        String timeLabel = "";
        if (TextUtils.isEmpty(time)) {
            return timeLabel;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
        long publishedTime = 0;
        try {
            Date date = format.parse(time);
            publishedTime = date.getTime();
        } catch (ParseException e) {
            e.printStackTrace();
        }
        if (publishedTime > 0) {
            Date Pubdate = new Date(publishedTime);
            Date nowDate = new Date();
            long temp = nowDate.getTime() - Pubdate.getTime();
            boolean isBefore = temp > 0;
            temp = Math.abs(temp);
            long years = temp / 1000 / 3600 / 24 / 365;
            long months = temp / 1000 / 3600 / 24 / 30;
            long days = temp / 1000 / 3600 / 24;
            long hours = temp / 1000 / 3600; // 相差小时数
            long mins = temp / 1000 / 60;

            /// >0 发布时间 在当前时间之前 < 0  发布时间为未来时间
            if (isBefore) {
                if (mins < 3) {
                    timeLabel = "刚刚";
                } else if (mins >= 3 && mins < 60) {
                    timeLabel = mins + "分钟前";
                } else if (mins >= 60 && hours < 24) {
                    timeLabel = hours + "小时前";
                } else if (hours >= 24 && days < 30) {
                    timeLabel = days + "天前";
                } else if (days >= 30 && years < 1) {
                    timeLabel = months + "个月前";
                } else if (years >= 1) {
                    timeLabel = years + "年前";
                }

            } else {

                if (mins < 3) {
                    timeLabel = "马上到";
                } else if (mins >= 3 && mins < 60) {
                    timeLabel = mins + "分钟后";
                } else if (mins >= 60 && hours < 24) {
                    timeLabel = hours + "小时后";
                } else if (hours >= 24 && days < 30) {
                    timeLabel = days + "天后";
                } else if (days >= 30 && years < 1) {
                    timeLabel = months + "个月后";
                } else if (years >= 1) {
                    timeLabel = years + "年后";
                }
            }
        }
        return timeLabel;
    }

    public static int compareDate(String date1, String date2, String formatStr) {
        int i = -2;
        if (!TextUtils.isEmpty(date1) && !TextUtils.isEmpty(date2)) {
            if (!TextUtils.isEmpty(formatStr)) {
                SimpleDateFormat format = new SimpleDateFormat(formatStr, Locale.getDefault());
                try {
                    Date d1 = format.parse(date1);
                    Date d2 = format.parse(date2);
                    if (d1.before(d2)) {
                        i = -1;
                    } else if (d1.after(d2)) {
                        i = 1;
                    } else if (d1.equals(d2)) {
                        i = 0;
                    }
                } catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }
        return i;
    }

    public static int compareDate(String date1, String date2, int addMinutes) {
        int i = -2;
        String formatStr = "yyyy-MM-dd HH:mm:ss";
        if (!TextUtils.isEmpty(date1) && !TextUtils.isEmpty(date2)) {
            SimpleDateFormat format = new SimpleDateFormat(formatStr, Locale.getDefault());
            try {
                Date d1 = format.parse(date1);
                d1.setMinutes(d1.getMinutes() + addMinutes);
                Date d2 = format.parse(date2);
                if (d1.before(d2)) {
                    i = -1;
                } else if (d1.after(d2)) {
                    i = 1;
                } else if (d1.equals(d2)) {
                    i = 0;
                }
            } catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return i;
    }

    public static int getBetweenDayOfYear(String strDate1, String strDate2,
                                          String formatStr) {
        int betweenDays = 0;
        if (!TextUtils.isEmpty(strDate1) && !TextUtils.isEmpty(strDate2)) {
            if (!TextUtils.isEmpty(formatStr)) {
                SimpleDateFormat format = new SimpleDateFormat(formatStr, Locale.getDefault());
                try {
                    Date date1 = format.parse(strDate1);
                    Date date2 = format.parse(strDate2);

                    Calendar calendar1 = Calendar.getInstance();
                    calendar1.setTime(date1);

                    Calendar calendar2 = Calendar.getInstance();
                    calendar2.setTime(date2);

                    betweenDays = calendar1.get(Calendar.DAY_OF_YEAR)
                            - calendar2.get(Calendar.DAY_OF_YEAR);
                } catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }
        return betweenDays;
    }


    /**
     * 获取当月当天 所在周的7个日期
     *
     * @return 周日 1  周一 2 3...6
     */
    public static List<Date> dateToWeek() {
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT, Locale.getDefault());
        Date mdate = new Date();
        int b = mdate.getDay();
        Date fdate;
        List<Date> list = new ArrayList<>();
        Long fTime = mdate.getTime() - b * 24 * 3600000;
        for (int a = 1; a <= 7; a++) {
            fdate = new Date();
//            fdate.setTime(fTime + (a * 24*3600000)); //一周从周日开始算，则使用此方式
//            fdate.setTime(fTime + ((a-1) * 24*3600000)); //一周从周一开始算，则使用此方式
            fdate.setTime(fTime + ((a - 1) * 24 * 3600000));
            list.add(a - 1, fdate);
        }
        return list;
    }

    /**
     * 获取当月当天前7个日期的字符串
     *
     * @param format 时间格式
     * @param count  当天多少天前的整形值
     * @return 当天前count个日期的字符串
     */
    public static List<String> getRecentSevenDate(String format, int count) {
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.getDefault());
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        List<String> result = new ArrayList<>(count);
        for (int a = count; a <= count; a--) {
            c.add(Calendar.DATE, 0 - a);
            Date date = c.getTime();
            String s = formatter.format(date);
            result.add(s);
        }
        return result;
    }

    public static String getYesterdayDate() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
        Calendar c = Calendar.getInstance();
        //过去七天
        c.setTime(new Date());
        c.add(Calendar.DATE, -1);
        Date d = c.getTime();
        String date = format.format(d);
        return date;
    }

    /**
     * 获取昨日短字符串（无时分秒）
     *
     * @return 昨天的字符串（只包含年-月-日）
     */
    public static String getYesterdayDateShort() {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT, Locale.getDefault());
        Calendar c = Calendar.getInstance();
        //过去七天
        c.setTime(new Date());
        c.add(Calendar.DATE, -1);
        Date d = c.getTime();
        String date = format.format(d);
        return date;
    }

    public static String getRecentSevenDayDate() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
        Calendar c = Calendar.getInstance();

        //过去七天
        c.setTime(new Date());
        c.add(Calendar.DATE, -7);
        Date d = c.getTime();
        String date = format.format(d);
        return date;
    }

    public static String getRecentSevenDayDateShort() {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT, Locale.getDefault());
        Calendar c = Calendar.getInstance();

        //过去七天
        c.setTime(new Date());
        c.add(Calendar.DATE, -7);
        Date d = c.getTime();
        String date = format.format(d);
        return date;
    }

    public static String getRecentMonthDate() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
        Calendar c = Calendar.getInstance();

        c.setTime(new Date());
        c.add(Calendar.MONTH, -1);
        Date m = c.getTime();
        String date = format.format(m);
        return date;
    }

    public static String getRecentMonthDateShort() {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT, Locale.getDefault());
        Calendar c = Calendar.getInstance();

        c.setTime(new Date());
        c.add(Calendar.MONTH, -1);
        Date m = c.getTime();
        String date = format.format(m);
        return date;
    }

    public static String dateStringToFormat(String dataString, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.getDefault());
        Date date = null;
        try {
            date = formatter.parse(dataString);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return formatter.format(date);
    }
}
