package com.mayi.fastdevelop.util;

import android.content.Context;
import android.view.View;

import com.mayi.fastdevelop.R;
import com.mayi.fastdevelop.view.dialog.BaseDialog;
import com.mayi.fastdevelop.view.dialog.DialogViewHolder;


/**
 * 常用对话框
 */
public class DialogUtils {

    public static BaseDialog showCommonDialog(final String titel, final String left, final String right, Context context, final DefaultDialogListener dialogListener) {
        return new BaseDialog(context, R.layout.dialog_default_sure) {
            @Override
            public void convert(DialogViewHolder holder) {
                holder.setText(R.id.tv_title, titel);
                holder.setText(R.id.tv_left, left);
                holder.setText(R.id.tv_right, right);
                holder.setOnClick(R.id.tv_right, new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        dismiss();
                        if (dialogListener != null) {
                            dialogListener.onClickRight();
                        }
                    }
                });
                holder.setOnClick(R.id.tv_left, new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        dismiss();
                        if (dialogListener != null) {
                            dialogListener.onClickLeft();
                        }
                    }
                });
            }
        }.setCanceledOnTouchOutside(true)
                .setCancelAble(true)
                .show();
    }

    public static BaseDialog showCommonDialog(String title, Context context, DefaultDialogListener listener) {
        return showCommonDialog(title, "取消", "确定", context, listener);
    }

    public static BaseDialog showTipsDialog(final String content, Context context, final TipsDialogListener listener) {
        return new BaseDialog(context, R.layout.dialog_default_tips) {
            @Override
            public void convert(DialogViewHolder holder) {
                holder.setText(R.id.tv_content, content);
                holder.setOnClick(R.id.tv_ok, new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        dismiss();
                        if (listener != null) {
                            listener.onClickOK();
                        }
                    }
                });
            }
        }.setCanceledOnTouchOutside(true)
                .setCancelAble(true)
                .show();
    }

    /**
     * 选择图片dialog
     * @param context
     * @param dialogListener
     * @return
     */
    public static BaseDialog showSelectPicturesDialog(Context context, final DefaultDialogListener dialogListener) {
        return new BaseDialog(context, R.layout.dialog_select_pictures) {
            @Override
            public void convert(DialogViewHolder holder) {
                holder.setOnClick(R.id.tv_album, new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        dismiss();
                        if (dialogListener != null) {
                            dialogListener.onClickRight();
                        }
                    }
                });
                holder.setOnClick(R.id.tv_photograph, new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        dismiss();
                        if (dialogListener != null) {
                            dialogListener.onClickLeft();
                        }
                    }
                });
            }
        }.setCanceledOnTouchOutside(true)
                .setCancelAble(true)
                .show();
    }


    public interface TipsDialogListener {
        void onClickOK();
    }

    public interface DefaultDialogListener {
        void onClickLeft();

        void onClickRight();
    }

}
