package com.mayi.fastdevelop.util;

import android.app.DownloadManager;
import android.app.DownloadManager.Request;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Environment;
import android.provider.MediaStore;
import android.webkit.MimeTypeMap;

import com.mayi.fastdevelop.comnon.Key;


/**
 * 下载更新的util 主要是负责 版本的相关更新工作
 * 实际 下载更新的具体步骤：
 * 将下载返回的ID存放在sharedPreference中
 * 如果成功就直接跳转到安装界面
 */
public class DownLoadUtil {
    public static String DOWNLOAD_FILE_NAME = "";

    //使用DownloadManager 下载
    public static void downLoadAPK(Context context, String url) {
        DOWNLOAD_FILE_NAME= System.currentTimeMillis()+".apk";
        Request request = new Request(Uri.parse(url));
        //设置状态栏中显示Notification
        request.setNotificationVisibility(Request.VISIBILITY_VISIBLE_NOTIFY_COMPLETED);
        //设置可用的网络类型
        request.setAllowedNetworkTypes(Request.NETWORK_MOBILE | Request.NETWORK_WIFI);
        //不显示下载界面
        request.setVisibleInDownloadsUi(true);
        //指定下载的路径为和上面创建的路径相同
        request.setDestinationInExternalPublicDir(Environment.DIRECTORY_DOWNLOADS, DOWNLOAD_FILE_NAME);
        //设置文件类型
        MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
        String mimeString = mimeTypeMap.getMimeTypeFromExtension(MimeTypeMap.getFileExtensionFromUrl(url));
        request.setMimeType(mimeString);
        request.setTitle(SystemUtil.getAppName(context));
        //将请求加入请求队列会 downLoadManager会自动调用对应的服务执行者个请求
        DownloadManager downLoadManager = (DownloadManager) context.getSystemService(Context.DOWNLOAD_SERVICE);
        if (downLoadManager != null) {
            long requestId = downLoadManager.enqueue(request);
            SpUtil.set(Key.ANT_DOWNLOAD_ID, requestId);
        }
    }

    ///获取当前下载进度
    public static int[] getBytesAndStatus(Context context, long downloadId) {
        DownloadManager downLoadManager = (DownloadManager) context.getSystemService(Context.DOWNLOAD_SERVICE);
        int[] bytesAndStatus = new int[]{-1, -1, 0};
        DownloadManager.Query query = new DownloadManager.Query().setFilterById(downloadId);
        Cursor c = null;
        try {
            if (downLoadManager != null) {
                c = downLoadManager.query(query);
                if (c != null && c.moveToFirst()) {
                    bytesAndStatus[0] = c.getInt(c.getColumnIndexOrThrow(DownloadManager.COLUMN_BYTES_DOWNLOADED_SO_FAR));
                    bytesAndStatus[1] = c.getInt(c.getColumnIndexOrThrow(DownloadManager.COLUMN_TOTAL_SIZE_BYTES));
                    bytesAndStatus[2] = c.getInt(c.getColumnIndex(DownloadManager.COLUMN_STATUS));
                }
            }
        } finally {
            if (c != null) {
                c.close();
            }
        }
        return bytesAndStatus;
    }

    //根据uri 获取实际路径
    public static String getRealPathFromURI(Context context, Uri contentURI) {
        String result;
        Cursor cursor = context.getContentResolver().query(contentURI,
                new String[]{MediaStore.Images.ImageColumns.DATA},//
                null, null, null);
        if (cursor == null) {
            result = contentURI.getPath();
        } else {
            cursor.moveToFirst();
            int index = cursor.getColumnIndex(MediaStore.Images.ImageColumns.DATA);
            result = cursor.getString(index);
            cursor.close();
        }
        return result;
    }

}