package com.mayi.fastdevelop.util;

import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.view.View;

//动态设置Drawable
public class DrawableUtils {

    /**
     * 设置view背景
      * @param view
     * @param str_strokeColor
     * @param str_fillColor 点击时颜色
     * @param str_unFillColor 未点击时颜色
     */
    public static void setStatePressedDrawable(View view,String str_strokeColor,String str_fillColor,String str_unFillColor){
        StateListDrawable drawable = new StateListDrawable();
        int strokeWidth = 1; // 1dp 边框宽度
        int roundRadius = 5; // 5dp 圆角半径
        int strokeColor = Color.parseColor(str_strokeColor);//边框颜色
        int fillColor = Color.parseColor(str_fillColor); //内部填充颜色
        GradientDrawable statePressed = new GradientDrawable();//创建drawable
        statePressed.setColor(fillColor);
        statePressed.setCornerRadius(roundRadius);
        statePressed.setStroke(strokeWidth, strokeColor);

        int unfillColor = Color.parseColor(str_unFillColor); //内部填充颜色
        GradientDrawable unStatePressed = new GradientDrawable();//创建drawable
        unStatePressed.setColor(unfillColor);
        unStatePressed.setCornerRadius(roundRadius);
        unStatePressed.setStroke(strokeWidth, strokeColor);

        drawable.addState(new int[]{android.R.attr.state_pressed}, statePressed);
        drawable.addState(new int[]{-android.R.attr.state_pressed}, unStatePressed);
        view.setBackground(drawable);
    }


}
