package com.mayi.fastdevelop.util;

import android.text.TextUtils;

import com.orhanobut.logger.Logger;
import com.tencent.bugly.crashreport.CrashReport;

/**
 * 日志记录工具类
 */
public class LogUtils {

    public static String TAG;

    /**
     * 错误信息上传bugly，已自定义错误的方式
     *
     * @param e
     */
    public static void postCatchedException(Exception e) {
        StringBuffer msg = new StringBuffer();
        if (!TextUtils.isEmpty(TAG)) {
            msg.append(TAG);
            msg.append("--");
        }
        msg.append(e.toString());
        Throwable throwable = new Throwable(msg.toString());
        throwable.setStackTrace(e.getStackTrace());
        CrashReport.postCatchedException(throwable);
    }

    /**
     * Logger为第三方jar，不要直接使用，防止以后需要替换
     *
     * @param msg
     */
    public static void i(String msg) {
        Logger.i(msg);
    }

    public static void d(String msg) {
        Logger.d(msg);
    }

    public static void v(String msg) {
        Logger.v(msg);
    }

    public static void w(String msg) {
        Logger.w(msg);
    }

    public static void e(String msg) {
        Logger.e(msg);
    }

    /**
     * 网络请求记录日志-网络请求成功,接口返回成功就算网络请求成功
     *
     * @param tag       发起请求的位置,要求定位到方法
     * @param url
     * @param parameter
     * @param result
     */
    public static void netWorkSuccess(String tag, String url, String parameter, String result) {
        Logger.i(tag + "  netWork Success   url=" + url + "  parameter=" +
                parameter + "  result=" + result);
    }

    /**
     * 网络请求记录日志-网络请求失败，并上传bugly
     *
     * @param tag       发起请求的位置,要求定位到方法
     * @param url
     * @param parameter
     * @param e
     */
    public static void netWorkFail(String tag, String url, String parameter, Exception e) {
        postCatchedException(e);
        Logger.i(tag + "  netWork Fail   url=" + url + "  parameter=" +
                parameter + "  Exception=" + e.toString());
    }

}
