package com.mayi.fastdevelop.util;

import android.content.Context;

import com.mayi.fastdevelop.base.BaseApplication;
import com.yanzhenjie.permission.Action;
import com.yanzhenjie.permission.AndPermission;
import com.yanzhenjie.permission.Rationale;
import com.yanzhenjie.permission.RequestExecutor;

import java.io.File;
import java.util.List;

public class PermissionUtil {

    /**
     * 请求权限
     *
     * @param callback
     * @param permissions
     */
    public static void requestPermission(final PermissionCallback callback, final String... permissions) {
        AndPermission.with(BaseApplication.getInstance().getChildApplication())
                .runtime()
                .permission(permissions)
                .onGranted(new Action<List<String>>() {
                    @Override
                    public void onAction(List<String> data) {
                        callback.onSuccess(data);
                    }
                })
                .onDenied(new Action<List<String>>() {
                    @Override
                    public void onAction(List<String> data) {
                        callback.onFail(data);
                    }
                }).start();
    }

    /**
     * 安装APP
     * @param callback
     * @param pathname
     */
    public static void installAPP(final PermissionInstallCallback callback, String pathname) {
        AndPermission.with(BaseApplication.getInstance().getChildApplication())
                .install()
                .file(new File(pathname))
                .rationale(new Rationale<File>() {
                    @Override
                    public void showRationale(Context c, File f, RequestExecutor e) {
                    }
                })
                .onGranted(new Action<File>() {
                    @Override
                    public void onAction(File data) {
                        callback.onSuccess();
                    }
                })
                .onDenied(new Action<File>() {
                    @Override
                    public void onAction(File data) {
                        callback.onFail();
                    }
                })
                .start();
    }

    public interface PermissionInstallCallback {
        void onSuccess();

        void onFail();
    }

    public interface PermissionCallback {
        void onSuccess(List<String> data);

        void onFail(List<String> data);
    }

}
