package com.mayi.fastdevelop.util;


import android.text.TextUtils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegUtil {

    /**
     * 验证密码 6-20位 必须数字字母组合
     */
    public static boolean isPwd(String pwd) {
        if (TextUtils.isEmpty(pwd))
            return false;
        Pattern p = Pattern.compile("^(?![0-9]+$)(?![a-zA-Z]+$)[0-9A-Za-z]{6,20}$");
        Matcher m = p.matcher(pwd);
        return m.matches();
    }

    /**
     * 验证邮箱
     */

    public static boolean isEmail(String strEmail) {
        if (TextUtils.isEmpty(strEmail))
            return false;
        Pattern p = Pattern.compile("^([a-zA-Z0-9_\\-\\.]+)@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.)|(([a-zA-Z0-9\\-]+\\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\\]?)$");
        Matcher m = p.matcher(strEmail);
        return m.matches();
    }

    /**
     * 验证手机格式
     *
     * @param mobiles
     * @return
     */
    public static boolean isPhone(String mobiles) {
        if (TextUtils.isEmpty(mobiles)) {
            return false;
        }
        return mobiles.matches("[1]\\d{10}");
    }

    /**
     * 判断是否中文
     *
     * @param str
     * @return
     */
    public static boolean isChinese(String str) {
        boolean temp = false;
        Pattern p = Pattern.compile("[\u4e00-\u9fa5]");
        Matcher m = p.matcher(str);
        if (m.find()) {
            temp = true;
        }
        return temp;
    }


}
