package com.mayi.fastdevelop.util;

import android.content.Context;
import android.text.TextUtils;
import android.widget.Toast;

/**
 * 公共的Toast
 */
public class ToastUtil {

    private static Toast sToast = null;

    public static Toast show(Context context, String msg) {
        return show(context, msg, Toast.LENGTH_SHORT);
    }

    public static Toast show(Context context, String msg, int duration) {
        if (TextUtils.isEmpty(msg) || context == null) {
            return null;
        }

        if (duration < Toast.LENGTH_SHORT) {
            duration = Toast.LENGTH_SHORT;
        }

        if (sToast == null) {
            sToast = Toast.makeText(context, msg, duration);
        } else {
            /**
             *适配8.0及以上版本，8.0不会更新Toast中的文字，要创建一个新的Toast
             */
            sToast.cancel();
            sToast = Toast.makeText(context, msg, duration);
        }
        sToast.show();
        return sToast;
    }

}