package com.mayi.fastdevelop.util;

import android.Manifest;
import android.content.Context;
import android.content.Intent;
import android.widget.Toast;

import com.mayi.fastdevelop.R;
import com.yanzhenjie.permission.AndPermission;
import com.yanzhenjie.permission.Permission;

import java.util.List;

public class ToolUtils {


    /**
     * 跳转扫码二维码页,先进行照相机权限判断，请求
     */
    public static void goScanActivity(final Context context, final Class activityClass) {
        if (AndPermission.hasPermissions(context, Manifest.permission.CAMERA)) {
            context.startActivity(new Intent(context, activityClass));
        } else {
            PermissionUtil.requestPermission(new PermissionUtil.PermissionCallback() {
                @Override
                public void onSuccess(List<String> data) {
                    context.startActivity(new Intent(context, activityClass));
                }

                @Override
                public void onFail(List<String> data) {
                    Toast.makeText(context, context.getString(R.string.error_take_photo), Toast.LENGTH_LONG).show();

                }
            }, Permission.CAMERA);
        }
    }

}
