package com.mayi.fastdevelop.view;

import android.widget.ImageView;

import com.mayi.fastdevelop.R;
import com.squareup.picasso.Picasso;

import java.io.File;

/**
 * 加载图片
 */
public class LoadingPictures {
    public static int error = R.mipmap.loading_pictures_error_icon;
    public static int placeholder = R.mipmap.loading_pictures_placeholder_icon;

    public static void loadUri(String url, ImageView img) {
        Picasso.with(img.getContext())
                .load(url)
                .resize(2000, 2000)
                .onlyScaleDown() // 如果图片规格大于2000*2000,将只会被resize
                .placeholder(placeholder)
                .error(error)
                .into(img);
    }

    public static void loadFile(File file, ImageView img) {
        Picasso.with(img.getContext())
                .load(file)
                .resize(2000, 2000)
                .placeholder(placeholder)
                .error(error)
                .into(img);
    }

    public static void loadFile(String pathname, ImageView img) {
        loadFile(new File(pathname),img);
    }

}
