package com.mayi.fastdevelop.view.lazyLoading;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;


/**
 * 列表懒加载控件
 */
public class ListLazyLoadingView extends RecyclerView {

    private LinearLayoutManager manager;
    private boolean isLoadingAll = false;//是否加载全部
    private int surplusItemCount = 5;
    private ListLazyLoadingViewListener listLazyLoadingViewListener;
    private boolean isLoading;//是否加载数据中

    public ListLazyLoadingView(@NonNull Context context) {
        super(context);
        init();
    }

    public ListLazyLoadingView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public ListLazyLoadingView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        init();
    }

    private int lastAction;

    private void init() {
        manager = new LinearLayoutManager(getContext(), VERTICAL, false);
        setLayoutManager(manager);

        setOnTouchListener(new OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                lastAction = event.getAction();
                return false;
            }
        });
        addOnScrollListener(new OnScrollListener() {
            @Override
            public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                if (!isLoadingAll && !isLoading) {
                    if (newState == SCROLL_STATE_IDLE && lastAction == MotionEvent.ACTION_UP) {
                        //获取最后一个完全显示的ItemPosition
                        int lastVisibleItem = manager.findLastCompletelyVisibleItemPosition();
                        int totalItemCount = manager.getItemCount();
                        if (totalItemCount - lastVisibleItem <= surplusItemCount) {
                            //加载更多功能的代码
                            if (listLazyLoadingViewListener != null) {
                                isLoading = true;
                                listLazyLoadingViewListener.onLoadMore();
                            }
                        }
                    }
                }
            }
        });
    }

    public void setListLazyLoadingAdapter(@Nullable ListLazyLoadingAdapter adapter) {
        setAdapter(adapter);
    }

    public boolean isLoadingAll() {
        return isLoadingAll;
    }

    public void setLoadingAll(boolean loadingAll) {
        isLoadingAll = loadingAll;
        Adapter adapter = getAdapter();
        if (adapter != null && adapter instanceof ListLazyLoadingAdapter) {
            ((ListLazyLoadingAdapter<ViewHolder>) adapter).setShowLoadMore(!loadingAll);
        }
    }

    public void setListLazyLoadingViewListener(ListLazyLoadingViewListener listLazyLoadingViewListener) {
        this.listLazyLoadingViewListener = listLazyLoadingViewListener;
    }

    public interface ListLazyLoadingViewListener {
        public void onLoadMore();
    }

    //完成加载更多
    public void finishLoadMore() {
        isLoading = false;
    }

}
