package com.mayi.fastdevelop.view.wheel;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;


import com.mayi.fastdevelop.R;
import com.mayi.fastdevelop.view.wheel.adapters.AbstractWheelTextAdapter;
import com.mayi.fastdevelop.view.wheel.views.CustomWheelView;
import com.mayi.fastdevelop.view.wheel.views.OnWheelChangedListener;
import com.mayi.fastdevelop.view.dialog.DialogViewHolder;
import com.mayi.fastdevelop.view.dialog.BaseDialog;

import java.util.ArrayList;
import java.util.Calendar;

import static java.lang.Integer.parseInt;

/**
 * 选择日期dialog
 */
public class ChangeDateDialog extends BaseDialog implements View.OnClickListener {

    private Context mContext;
    private OnDateListener onTimeListener;
    private ArrayList<String> array_years = new ArrayList<>();
    private ArrayList<String> array_months = new ArrayList<>();
    private ArrayList<String> array_days = new ArrayList<>();
    private CalendarTextAdapter mYearAdapter;
    private CalendarTextAdapter mMonthAdapter;
    private CalendarTextAdapter mDaydapter;
    private CalendarTextAdapter mHourAdapter;
    private CalendarTextAdapter mMinuteAdapter;
    private String mYear, mMonth, mDay, mHour, mMinute;

    private CustomWheelView wvYear;
    private CustomWheelView wvMonth;
    private CustomWheelView wvDay;

    private TextView btnSure;
    private TextView btnCancel;

    private int day;
    private int currentYear, currentMonth, currentDay;

    private int maxTextSize = 20;
    private int minTextSize = 14;

    public ChangeDateDialog(Context context, OnDateListener onTimeListener) {
        super(context, R.layout.view_wheel_date);
        this.mContext = context;
        this.onTimeListener = onTimeListener;
        getDate();
        initDataAndBindEvent();
    }

    private void getDate() {
        this.currentYear = getYear();
        this.currentMonth = getMonth();
        this.currentDay = getDay();

        calDays(currentYear, currentMonth);/*计算当月天数*/
    }

    private void initDataAndBindEvent() {
        initYears();
        mYearAdapter = new CalendarTextAdapter(mContext, array_years, 1, maxTextSize, minTextSize);
        wvYear.setVisibleItems(5);
        wvYear.setViewAdapter(mYearAdapter);
        wvYear.setCurrentItem(1);
        mYear = array_years.get(1);

        initMonths();
        mMonthAdapter = new CalendarTextAdapter(mContext, array_months, currentMonth, maxTextSize, minTextSize);
        wvMonth.setVisibleItems(5);
        wvMonth.setViewAdapter(mMonthAdapter);
        wvMonth.setCurrentItem(currentMonth - 1);
        mMonth = array_months.get(currentMonth - 1);

        initDays(day);
        mDaydapter = new CalendarTextAdapter(mContext, array_days, currentDay - 1, maxTextSize, minTextSize);
        wvDay.setVisibleItems(5);
        wvDay.setViewAdapter(mDaydapter);
        wvDay.setCurrentItem(currentDay - 1);
        mDay = array_days.get(currentDay - 1);

        wvYear.addChangingListener(new OnWheelChangedListener() {

            @Override
            public void onChanged(CustomWheelView wheel, int oldValue, int newValue) {
                mYear = (String) mYearAdapter.getItemText(wheel.getCurrentItem());
                currentYear = parseInt(mYear);
            }
        });

        wvMonth.addChangingListener(new OnWheelChangedListener() {

            @Override
            public void onChanged(CustomWheelView wheel, int oldValue, int newValue) {
                mMonth = (String) mMonthAdapter.getItemText(wheel.getCurrentItem());
                currentMonth = parseInt(mMonth);
                calDays(currentYear, currentMonth);
                initDays(day);
                mDaydapter = new CalendarTextAdapter(mContext, array_days, currentDay - 1, maxTextSize, minTextSize);
                wvDay.setVisibleItems(5);
                wvDay.setViewAdapter(mDaydapter);
                wvDay.setCurrentItem(currentDay - 1);
            }
        });

        wvDay.addChangingListener(new OnWheelChangedListener() {

            @Override
            public void onChanged(CustomWheelView wheel, int oldValue, int newValue) {
                mDay = (String) mDaydapter.getItemText(wheel.getCurrentItem());
                currentDay = parseInt(mDay);
            }
        });
    }

    private void initYears() {
        array_years.clear();
        for (int i = currentYear - 1; i <= currentYear + 1; i++) {
            array_years.add(String.valueOf(i));
        }
    }

    private void initMonths() {
        array_months.clear();
        for (int i = 1; i <= 12; i++) {
            array_months.add(String.valueOf(i));
        }
    }

    private void initDays(int days) {
        array_days.clear();
        for (int i = 1; i <= days; i++) {
            array_days.add(String.valueOf(i));
        }
    }

    /**
     * 计算每月多少天
     */
    public void calDays(int yrear, int month) {
        boolean leayyear;
        if (currentYear % 4 == 0 && currentYear % 100 != 0) {
            leayyear = true;
        } else {
            leayyear = false;
        }
        for (int i = 1; i <= 12; i++) {
            switch (month) {

                case 1:
                case 3:
                case 5:
                case 7:
                case 8:
                case 10:
                case 12:
                    this.day = 31;
                    break;
                case 2:
                    if (leayyear) {
                        this.day = 29;
                    } else {
                        this.day = 28;
                    }
                    break;
                case 4:
                case 6:
                case 9:
                case 11:
                    this.day = 30;
                    break;
            }
        }
    }


    private int getYear() {
        Calendar c = Calendar.getInstance();
        return c.get(Calendar.YEAR);
    }

    private int getMonth() {
        Calendar c = Calendar.getInstance();
        return c.get(Calendar.MONTH) + 1;
    }

    private int getDay() {
        Calendar c = Calendar.getInstance();
        return c.get(Calendar.DAY_OF_MONTH);
    }

    public interface OnDateListener {
        void onClick(String year, String month, String day);
    }

    @Override
    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.txt_complete) {
            if (onTimeListener != null) {
                mMonth = parseInt(mMonth) > 9 ? mMonth : "0" + mMonth;
                mDay = parseInt(mDay) > 9 ? mDay : "0" + mDay;
                onTimeListener.onClick(mYear, mMonth, mDay);
            }
            dismiss();
        } else if (i == R.id.txt_think) {
            dismiss();
        }
    }

    @Override
    public void convert(DialogViewHolder holder) {
        View view = holder.getConvertView();
        wvYear = (CustomWheelView) view.findViewById(R.id.wv_year);
        wvMonth = (CustomWheelView) view.findViewById(R.id.wv_month);
        wvDay = (CustomWheelView) view.findViewById(R.id.wv_day);

        btnSure = (TextView) view.findViewById(R.id.txt_complete);
        btnCancel = (TextView) view.findViewById(R.id.txt_think);
        btnSure.setOnClickListener(this);
        btnCancel.setOnClickListener(this);
    }

    private class CalendarTextAdapter extends AbstractWheelTextAdapter {
        ArrayList<String> list;

        protected CalendarTextAdapter(Context context, ArrayList<String> list, int currentItem, int maxsize, int minsize) {
            super(context, R.layout.item_birth_year, NO_RESOURCE, currentItem, maxsize, minsize);
            this.list = list;
            setItemTextResource(R.id.tempValue);
        }

        @Override
        public View getItem(int index, View cachedView, ViewGroup parent) {
            View view = super.getItem(index, cachedView, parent);
            return view;
        }

        @Override
        public int getItemsCount() {
            return list.size();
        }

        @Override
        protected CharSequence getItemText(int index) {
            return list.get(index) + "";
        }
    }
}
