package com.mayi.fastdevelop.view.wheel;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.mayi.fastdevelop.R;
import com.mayi.fastdevelop.view.wheel.adapters.AbstractWheelTextAdapter;
import com.mayi.fastdevelop.view.wheel.views.CustomWheelView;
import com.mayi.fastdevelop.view.wheel.views.OnWheelChangedListener;
import com.mayi.fastdevelop.view.dialog.BaseDialog;
import com.mayi.fastdevelop.view.dialog.DialogViewHolder;

import java.util.ArrayList;
import java.util.Calendar;

import static java.lang.Integer.parseInt;

/**
 * 日期时间对话框
 */
public class ChangeTimeDialog extends BaseDialog implements View.OnClickListener {

    private Context mContext;
    private OnTimeListener onTimeListener;
    private ArrayList<String> array_years = new ArrayList<>();
    private ArrayList<String> array_months = new ArrayList<>();
    private ArrayList<String> array_days = new ArrayList<>();
    private ArrayList<String> array_hours = new ArrayList<>();
    private ArrayList<String> array_minutes = new ArrayList<>();
    private CalendarTextAdapter mYearAdapter;
    private CalendarTextAdapter mMonthAdapter;
    private CalendarTextAdapter mDaydapter;
    private CalendarTextAdapter mHourAdapter;
    private CalendarTextAdapter mMinuteAdapter;
    private String mYear, mMonth, mDay, mHour, mMinute;

    private CustomWheelView wvYear;
    private CustomWheelView wvMonth;
    private CustomWheelView wvDay;
    private CustomWheelView wvHour;
    private CustomWheelView wvMinute;

    private TextView btnSure;
    private TextView btnCancel;

    private int day;
    private int currentYear, currentMonth, currentDay, currentHour, currentMinute;

    private int maxTextSize = 20;
    private int minTextSize = 14;
    private boolean isDismiss = true;

    public ChangeTimeDialog(Context context, OnTimeListener onTimeListener) {
        super(context, R.layout.view_wheel_time);
        this.mContext = context;
        this.onTimeListener = onTimeListener;
        getDate();
        initDataAndBindEvent();
    }

    public ChangeTimeDialog(Context context, OnTimeListener onTimeListener, boolean isDismiss) {
        super(context, R.layout.view_wheel_time);
        this.mContext = context;
        this.onTimeListener = onTimeListener;
        this.isDismiss = isDismiss;
        getDate();
        initDataAndBindEvent();
    }

    public void setDismiss(boolean dismiss) {
        isDismiss = dismiss;
    }

    private void getDate() {
        this.currentYear = getYear();
        this.currentMonth = getMonth();
        this.currentDay = getDay();
        this.currentHour = getHour();
        this.currentMinute = getMinute();
        calDays(currentYear, currentMonth);/*计算当月天数*/
    }

    private void initDataAndBindEvent() {
        initYears();
        mYearAdapter = new CalendarTextAdapter(mContext, array_years, 1, maxTextSize, minTextSize);
        wvYear.setVisibleItems(5);
        wvYear.setViewAdapter(mYearAdapter);
        wvYear.setCurrentItem(1);
        mYear = array_years.get(1);

        initMonths();
        mMonthAdapter = new CalendarTextAdapter(mContext, array_months, currentMonth, maxTextSize, minTextSize);
        wvMonth.setVisibleItems(5);
        wvMonth.setViewAdapter(mMonthAdapter);
        wvMonth.setCurrentItem(currentMonth - 1);
        mMonth = array_months.get(currentMonth - 1);

        initDays(day);
        mDaydapter = new CalendarTextAdapter(mContext, array_days, currentDay - 1, maxTextSize, minTextSize);
        wvDay.setVisibleItems(5);
        wvDay.setViewAdapter(mDaydapter);
        wvDay.setCurrentItem(currentDay - 1);
        mDay = array_days.get(currentDay - 1);

        initHours();
        mHourAdapter = new CalendarTextAdapter(mContext, array_hours, currentHour, maxTextSize, minTextSize);
        wvHour.setVisibleItems(5);
        wvHour.setViewAdapter(mHourAdapter);
        wvHour.setCurrentItem(currentHour);
        mHour = array_hours.get(currentHour);

        initMinute();
        mMinuteAdapter = new CalendarTextAdapter(mContext, array_minutes, currentMinute - 1, maxTextSize, minTextSize);
        wvMinute.setVisibleItems(5);
        wvMinute.setViewAdapter(mMinuteAdapter);
        wvMinute.setCurrentItem(currentMinute);
        mMinute = array_minutes.get(currentMinute);
        wvYear.addChangingListener(new OnWheelChangedListener() {

            @Override
            public void onChanged(CustomWheelView wheel, int oldValue, int newValue) {
                mYear = (String) mYearAdapter.getItemText(wheel.getCurrentItem());
                currentYear = parseInt(mYear);
            }
        });

        wvMonth.addChangingListener(new OnWheelChangedListener() {

            @Override
            public void onChanged(CustomWheelView wheel, int oldValue, int newValue) {
                mMonth = (String) mMonthAdapter.getItemText(wheel.getCurrentItem());
                currentMonth = parseInt(mMonth);
                calDays(currentYear, currentMonth);
                initDays(day);
                mDaydapter = new CalendarTextAdapter(mContext, array_days, currentDay - 1, maxTextSize, minTextSize);
                wvDay.setVisibleItems(5);
                wvDay.setViewAdapter(mDaydapter);
                wvDay.setCurrentItem(currentDay - 1);
            }
        });

        wvDay.addChangingListener(new OnWheelChangedListener() {

            @Override
            public void onChanged(CustomWheelView wheel, int oldValue, int newValue) {
                mDay = (String) mDaydapter.getItemText(wheel.getCurrentItem());
                currentDay = parseInt(mDay);
            }
        });

        wvHour.addChangingListener(new OnWheelChangedListener() {

            @Override
            public void onChanged(CustomWheelView wheel, int oldValue, int newValue) {
                mHour = (String) mHourAdapter.getItemText(wheel.getCurrentItem());
                currentHour = parseInt(mHour);
            }
        });

        wvMinute.addChangingListener(new OnWheelChangedListener() {

            @Override
            public void onChanged(CustomWheelView wheel, int oldValue, int newValue) {
                mMinute = (String) mMinuteAdapter.getItemText(wheel.getCurrentItem());
                currentMinute = parseInt(mMinute);
            }
        });
    }


    private void initYears() {
        array_years.clear();
        for (int i = currentYear - 1; i <= currentYear + 1; i++) {
            array_years.add(String.valueOf(i));
        }
    }

    private void initMonths() {
        array_months.clear();
        for (int i = 1; i <= 12; i++) {
            array_months.add(String.valueOf(i));
        }
    }

    private void initDays(int days) {
        array_days.clear();
        for (int i = 1; i <= days; i++) {
            array_days.add(String.valueOf(i));
        }
    }

    private void initHours() {
        array_hours.clear();
        for (int i = 0; i < 24; i++) {
            array_hours.add(String.valueOf(i));
        }
    }

    private void initMinute() {
        array_minutes.clear();
        for (int i = 0; i < 60; i++) {
            array_minutes.add(String.valueOf(i));
        }
    }

    /**
     * 计算每月多少天
     */
    public void calDays(int yrear, int month) {
        boolean leayyear;
        if (currentYear % 4 == 0 && currentYear % 100 != 0) {
            leayyear = true;
        } else {
            leayyear = false;
        }
        for (int i = 1; i <= 12; i++) {
            switch (month) {
                case 1:
                case 3:
                case 5:
                case 7:
                case 8:
                case 10:
                case 12:
                    this.day = 31;
                    break;
                case 2:
                    if (leayyear) {
                        this.day = 29;
                    } else {
                        this.day = 28;
                    }
                    break;
                case 4:
                case 6:
                case 9:
                case 11:
                    this.day = 30;
                    break;
            }
        }
    }


    private int getYear() {
        Calendar c = Calendar.getInstance();
        return c.get(Calendar.YEAR);
    }

    private int getMonth() {
        Calendar c = Calendar.getInstance();
        return c.get(Calendar.MONTH) + 1;
    }

    private int getDay() {
        Calendar c = Calendar.getInstance();
        return c.get(Calendar.DAY_OF_MONTH);
    }

    private int getHour() {
        Calendar c = Calendar.getInstance();
        return c.get(Calendar.HOUR_OF_DAY);
    }

    private int getMinute() {
        Calendar c = Calendar.getInstance();
        return c.get(Calendar.MINUTE);
    }

    public interface OnTimeListener {
        void onClick(String year, String month, String day, String hour, String minute);
    }

    @Override
    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.txt_complete) {
            if (onTimeListener != null) {
                mMonth = Integer.parseInt(mMonth) > 9 ? mMonth : "0" + Integer.parseInt(mMonth);
                mDay = Integer.parseInt(mDay) > 9 ? mDay : "0" + Integer.parseInt(mDay);
                mHour = Integer.parseInt(mHour) > 9 ? mHour : "0" + Integer.parseInt(mHour);
                mMinute = Integer.parseInt(mMinute) > 9 ? mMinute : "0" + Integer.parseInt(mMinute);
                onTimeListener.onClick(mYear, mMonth, mDay, mHour, mMinute);
            }

            if (isDismiss) {
                dismiss();
            }
        } else if (i == R.id.txt_think) {
            dismiss();
        }
    }

    @Override
    public void convert(DialogViewHolder holder) {
        View view = holder.getConvertView();
        wvYear = (CustomWheelView) view.findViewById(R.id.wv_year);
        wvMonth = (CustomWheelView) view.findViewById(R.id.wv_month);
        wvDay = (CustomWheelView) view.findViewById(R.id.wv_day);
        wvHour = (CustomWheelView) view.findViewById(R.id.wv_hour);
        wvMinute = (CustomWheelView) view.findViewById(R.id.wv_minute);

        btnSure = (TextView) view.findViewById(R.id.txt_complete);
        btnCancel = (TextView) view.findViewById(R.id.txt_think);
        btnSure.setOnClickListener(this);
        btnCancel.setOnClickListener(this);
    }

    private class CalendarTextAdapter extends AbstractWheelTextAdapter {
        ArrayList<String> list;

        protected CalendarTextAdapter(Context context, ArrayList<String> list, int currentItem, int maxsize, int minsize) {
            super(context, R.layout.item_birth_year, NO_RESOURCE, currentItem, maxsize, minsize);
            this.list = list;
            setItemTextResource(R.id.tempValue);
        }

        @Override
        public View getItem(int index, View cachedView, ViewGroup parent) {
            View view = super.getItem(index, cachedView, parent);
            return view;
        }

        @Override
        public int getItemsCount() {
            return list.size();
        }

        @Override
        protected CharSequence getItemText(int index) {
            return list.get(index) + "";
        }
    }
}
