/*
 *  /**
 *   * Copyright &copy; 2017-2020  All rights reserved.
 *   * Licensed under the yen License, Version 1.0 (the "License");
 *
 */

package com.mayi.fastdevelop.view.wheel.views;

/**
 * Wheel clicked listener interface.
 * <p>
 * The onItemClicked() method is called whenever a wheel item is clicked
 * <li>New Wheel position is set
 * <li>Wheel view is scrolled
 */
public interface OnWheelClickedListener {
	/**
	 * Callback method to be invoked when current item clicked
	 * 
	 * @param wheel
	 *            the wheel view
	 * @param itemIndex
	 *            the index of clicked item
	 */
	void onItemClicked(CustomWheelView wheel, int itemIndex);
}
