package com.mayi.fastdevelop.map;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;

import com.gc.call.CallImmediatelyHandlerTarget;
import com.gc.call.CallParticipationBean;
import com.gc.call.CallReturnBean;
import com.mayi.fastdevelop.comnon.RequestCode;
import com.mayi.fastdevelop.util.PermissionUtil;
import com.mayi.fastdevelop.util.ToastUtil;
import com.yanzhenjie.permission.Permission;

import java.util.List;

//跳转地图定位页
public class GoMapLocationCallTarget extends CallImmediatelyHandlerTarget {
    @Override
    public String getTag() {
        return "map_goMapLocation";
    }

    @Override
    public CallReturnBean onHandle(CallParticipationBean bean) {
        Context context = bean.getContext();
        if (context != null) {
            PermissionUtil.requestPermission(new PermissionUtil.PermissionCallback() {
                @Override
                public void onSuccess(List<String> data) {
                    goMapLocationActivity(context);
                }

                @Override
                public void onFail(List<String> data) {
                    ToastUtil.show(context,"没有定位权限，无法定位！");
                    goMapLocationActivity(context);
                }
            }, Permission.Group.LOCATION);

        }
        return null;
    }

    private void goMapLocationActivity(Context context) {
        Intent intent = new Intent(context, MapLocationActivity.class);
        if (context instanceof Activity) {
            ((Activity) context).startActivityForResult(intent,
                    RequestCode.MAP_LOCATION_ACTIVITY_RESULTCODE);
        }
    }
}
