package com.mayi.fastdevelop.map;

import com.alibaba.fastjson.JSON;
import com.gc.call.CallParticipationBean;
import com.gc.call.CallReturnBean;
import com.gc.call.CallTimeHandTarget;
import com.gc.call.CallTimeHandlerListener;
import com.mayi.fastdevelop.bean.LocationBean;

public class LocationCallTarget extends CallTimeHandTarget {
    @Override
    public String getTag() {
        return "map_location";
    }

    @Override
    public void delayProcessing(CallParticipationBean bean, final CallTimeHandlerListener listener) {
        LocationUtils.startLocation(bean.getContext(), new LocationUtils.LocationCallback() {
            @Override
            public void onFail(String msg) {
                CallReturnBean callReturnBean = new CallReturnBean();
                callReturnBean.setMsg(msg);
                callReturnBean.setCode(-3);
                listener.timeHandler(callReturnBean);
            }

            @Override
            public void onSuccess(LocationBean bean) {
                CallReturnBean callReturnBean = new CallReturnBean();
                callReturnBean.setReturnJson(JSON.toJSONString(bean));
                listener.timeHandler(callReturnBean);
            }
        });
    }
}
