package com.mayi.fastdevelop.web;

import android.os.Build;

import com.mayi.fastdevelop.base.BaseApplication;
import com.mayi.fastdevelop.util.LogUtils;
import com.tencent.smtt.sdk.CookieManager;
import com.tencent.smtt.sdk.CookieSyncManager;
import com.tencent.smtt.sdk.QbSdk;
import com.tencent.smtt.sdk.WebStorage;

public class WebUtil {

    /**
     * 初始化浏览器
     */
    public static void initX5Webview() {
        //清空所有Cookie
        CookieSyncManager.createInstance(BaseApplication.getInstance().getChildApplication().getApplicationContext());
        CookieManager cookieManager = CookieManager.getInstance();
        cookieManager.removeSessionCookies(null);
        cookieManager.removeAllCookie();
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            cookieManager.flush();
        } else {
            CookieSyncManager.getInstance().sync();
        }
        WebStorage.getInstance().deleteAllData();

        //搜集本地tbs内核信息并上报服务器，服务器返回结果决定使用哪个内核。
        QbSdk.PreInitCallback cb = new QbSdk.PreInitCallback() {

            @Override
            public void onViewInitFinished(boolean arg0) {
                //x5內核初始化完成的回调，为true表示x5内核加载成功，否则表示x5内核加载失败，会自动切换到系统内核。
                LogUtils.i("X5内核加载完成:" + arg0);
            }

            @Override
            public void onCoreInitFinished() {
            }
        };
        //x5内核初始化接口
        QbSdk.initX5Environment(BaseApplication.getInstance().getChildApplication().getApplicationContext(), cb);
    }

}
